<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AmountCashStatementCurrency extends Model 
{

    protected $table = 'amount_cash_statements_currencies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cash_statement_id', 'currency_id', 'amount', 'status');
    protected $visible = array('cash_statement_id', 'currency_id', 'amount', 'status');

    public function cashStatement()
    {
        return $this->belongsTo('App\Models\CashStatement', 'cash_statement_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

}